USE [EleriumClean]
GO

/****** Object:  Table [dbo].[RewardDailyBudget]    Script Date: 10/3/2013 8:11:39 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[RewardDailyBudget](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[MonthlyBudgetID] [int] NOT NULL,
	[ActualBonusPointsAdded] [money] NULL,
	[AddonPercentage] [decimal](3, 2) NOT NULL,
	[BonusPercentage] [decimal](3, 2) NOT NULL,
	[DailyBudgetDate] [date] NOT NULL,
	[DailyPoints] [money] NOT NULL,
	[DailyPermiumBudget] [money] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[Fairness] [decimal](3, 2) NOT NULL,
	[LibraryPercentage] [decimal](3, 2) NOT NULL,
	[LibraryThreshold] [int] NOT NULL,
	[PopularityThreshold] [int] NOT NULL,
 CONSTRAINT [PK_DailyPointBudget] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

ALTER TABLE [dbo].[RewardDailyBudget]  WITH CHECK ADD  CONSTRAINT [FK_RewardDailyBudget_MonthlyBudget] FOREIGN KEY([MonthlyBudgetID])
REFERENCES [dbo].[RewardMonthlyBudget] ([ID])
GO

ALTER TABLE [dbo].[RewardDailyBudget] CHECK CONSTRAINT [FK_RewardDailyBudget_MonthlyBudget]
GO

ALTER TABLE [dbo].[RewardDailyBudget]  WITH CHECK ADD  CONSTRAINT [CK_DailyBudget_AddonPercentage] CHECK  (([AddonPercentage]<=(1.0)))
GO

ALTER TABLE [dbo].[RewardDailyBudget] CHECK CONSTRAINT [CK_DailyBudget_AddonPercentage]
GO

ALTER TABLE [dbo].[RewardDailyBudget]  WITH CHECK ADD  CONSTRAINT [CK_DailyBudget_BonusPercentage] CHECK  (([BonusPercentage]<=(1.0)))
GO

ALTER TABLE [dbo].[RewardDailyBudget] CHECK CONSTRAINT [CK_DailyBudget_BonusPercentage]
GO

ALTER TABLE [dbo].[RewardDailyBudget]  WITH CHECK ADD  CONSTRAINT [CK_DailyBudget_Fairness] CHECK  (([Fairness]<=(1.0)))
GO

ALTER TABLE [dbo].[RewardDailyBudget] CHECK CONSTRAINT [CK_DailyBudget_Fairness]
GO

ALTER TABLE [dbo].[RewardDailyBudget]  WITH CHECK ADD  CONSTRAINT [CK_DailyBudget_LibraryPercentage] CHECK  (([LibraryPercentage]<=(1.0)))
GO

ALTER TABLE [dbo].[RewardDailyBudget] CHECK CONSTRAINT [CK_DailyBudget_LibraryPercentage]
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The actual bonus points added on a given day, based on the BonusPercentage as well as any fractions of points leftover during the generation.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RewardDailyBudget', @level2type=N'COLUMN',@level2name=N'ActualBonusPointsAdded'
GO


